/*
 * Decompiled with CFR 0.152.
 */
package net.pevori.queencats.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.File;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class QueenCatsConfig {
    public static final Server SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;

    public static void loadConfig(ForgeConfigSpec config, String path) {
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(path)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        file.load();
        config.setConfig((CommentedConfig)file);
    }

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Server::new);
        SERVER = (Server)commonSpecPair.getLeft();
        SERVER_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
    }

    public static class Server {
        public final ForgeConfigSpec.ConfigValue<Boolean> enable_humanoid_cat_sounds;
        public final ForgeConfigSpec.ConfigValue<Boolean> enable_humanoid_dog_sounds;
        public final ForgeConfigSpec.ConfigValue<Boolean> enable_humanoid_bunny_sounds;
        public final ForgeConfigSpec.ConfigValue<Boolean> enable_humanoid_cow_sounds;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.push("Humanoid Animal Sounds");
            this.enable_humanoid_cat_sounds = builder.translation("text.queencats.config.enable_humanoid_cat_sounds").define("Enable Humanoid Cat Sounds", true);
            this.enable_humanoid_dog_sounds = builder.translation("text.queencats.config.enable_humanoid_dog_sounds").define("Enable Humanoid Dog Sounds", true);
            this.enable_humanoid_bunny_sounds = builder.translation("text.queencats.config.enable_humanoid_bunny_sounds").define("Enable Humanoid Bunny Sounds", true);
            this.enable_humanoid_cow_sounds = builder.translation("text.queencats.config.enable_humanoid_cow_sounds").define("Enable Humanoid Cow Sounds", true);
            builder.pop();
        }
    }
}

